// Top Secret Crypto Gold for Windows
//...................................

// Copyright  2000 - 2005 by TAN$TAAFL Software Company
//						      14 Foster St., Banician
//                            Olongapo City 2200
//                            Philippines

// This source code is NOT IN THE PUBLIC DOMAIN and is NOT OPEN SOURCE.
// It is provided solely for the purpose of letting you determine how
// the program works, and that there are no backdoors or hidden code
// in the program. Anyone that wants to use any portion of this code
// in their own program please contact the author at:

//							  MacGregor K. Phillips
//                            PSC 517 Box RS
//                            FPO AP 96517-1000

#include <windows.h>  
#include "Tsc.h"
#include "ContextHelp.h"
#include "Prototypes.h"
#include <Shlwapi.h>
#include <Commctrl.h>
#include <htmlhelp.h>
#include "Tscmsg.h"
#include "Check.h"

extern	HHOOK				hHook;
extern	HHOOK				hMouseHook;
extern	LPCTSTR				lpIconPointer;
extern	LPCTSTR				lpszAppName;
extern	LPTSTR				lpszNA;
extern	HINSTANCE			hInst;
extern	HWND				hDlgModeLess1;
extern	HWND				hDlgCurrent;
extern	HWND				hMainWindow;
extern	TCHAR				szPublicRingKeyId[MAX_PATH];
extern	TCHAR				szPublicRingUserId[MAX_PATH];
extern	TCHAR				szSecretRingKeyId[MAX_PATH];
extern	TCHAR				szSecretRingUserId[MAX_PATH];
extern	TCHAR				szBackUpFile[MAX_PATH];
extern	HANDLE				hPublicKeyRing;
extern	HANDLE				hPublicRingKeyId;
extern	HANDLE				hPublicRingUserId;
extern	HANDLE				hSecretKeyRing;
extern	HANDLE				hSecretRingKeyId;
extern	HANDLE				hSecretRingUserId;
extern	HANDLE				hBackUpFile;
extern	DWORD				dwKeyRingFilesActive;
extern	LPBYTE				lpKeyBuffer1;
extern	LPBYTE				lpKeyBuffer2;
extern	BYTE				TempOwnerId;
extern	BOOL				bTrapTheTabKey;
extern	BOOL				bNeedUKey;
extern	BOOL				bNeedChatKey;
extern	LPBYTE				lpKeyBufferDup1;
extern	CONFIG				cfg;

// Default index handle, file pointer, record size and buffer.
// Move data for whichever index is active to here for processing
// by procedures. Group One.
//...............................................................
DWORD		dwIdxOffset1;			// File pointer
LPVOID		lpIdxBuffer1;			// Address of index file buffer
DWORD		dwEndIdxOffset1;		// File pointer to end of file
HANDLE		hIdxHandle1;			// Handle
HANDLE		hKeyHandle1;			// Handle
DWORD		dwIdxSize1;				// Size of index structure
LPBYTE		lpRingFile1;			// Pointer to ring file name
LPBYTE		lpIndexFile1;			// Pointer to index file name
DWORD		dwRecordLength1;		// Record length in key ring file
DWORD		dwRingFileOffset1;		// File pointer in key ring file

// Group Two variables allows us to handle two files at the same time.
// Useful when checking public keys against secret keys, or signing
// keys, or checking signatures.
//....................................................................
DWORD		dwIdxOffset2;
LPVOID		lpIdxBuffer2;
DWORD		dwEndIdxOffset2;
HANDLE		hIdxHandle2;
HANDLE		hKeyHandle2;
DWORD		dwIdxSize2;
LPBYTE		lpRingFile2;
LPBYTE		lpIndexFile2;
DWORD		dwRecordLength2;
DWORD		dwRingFileOffset2;

// Variables that tell us if we have public or secret key packets
// or keys deleted.
//...............................................................
DWORD		dwPublicDeleted = 0;
DWORD		dwSecretDeleted = 0;

// Index file structures for the key id and user id index files
// for the public and secret key rings.
//..............................................................
U_IDX_FMT	UserIdIndex1;
U_IDX_FMT	UserIdIndex2;
K_IDX_FMT	KeyIdIndex1;
K_IDX_FMT	KeyIdIndex2;

// Pointers to the Index structures for the user and key
// id index files.
//......................................................
LPU_IDX_FMT		lpUserIdBuffer1 = &UserIdIndex1;
LPU_IDX_FMT		lpUserIdBuffer2 = &UserIdIndex2;
LPK_IDX_FMT		lpKeyIdBuffer1 = &KeyIdIndex1;
LPK_IDX_FMT		lpKeyIdBuffer2 = &KeyIdIndex2;

// Public and secret key ring file positions.
//...........................................
DWORD		dwPublicFilePosition;
DWORD		dwSecretFilePosition;

// Sort and search templates for the user and key id index files.
//...............................................................
SORT_TEMPLATE	KeyIdSort = {SORT_BYTES,FORWARD,sizeof(K_IDX_FMT),8,8,SORT_END};
SORT_TEMPLATE	UserIdSort = {SORT_STRINGS,FORWARD,sizeof(U_IDX_FMT),255,16,SORT_END};

SEARCH_TEMPLATE		KeyIdSearch = {SORT_BYTES,FORWARD,sizeof(K_IDX_FMT),8,8};
SEARCH_TEMPLATE		UserIdSearch = {SORT_BYTES,FORWARD,sizeof(U_IDX_FMT),255,16};

// Data for the rsa key files. Keeps track of the number of keys
// and user ids in a secret key ring, and the number of keys,
// user ids, and signatures in a public key ring.
//..............................................................
DWORD		dwPublicKeys;
DWORD		dwPublicIds;
DWORD		dwPublicSigs;
DWORD		dwCompromiseSigs;
DWORD		dwSecretKeys;
DWORD		dwSecretIds;

// Operation for the set/edit owner trust dialog.
//...............................................
DWORD		dwOwnerOperation;
UINT		uiCurrentTrustSetting;

// Used by the edit procedures in Edit.c.
//.......................................
BOOL		bKeysEdited;
BOOL		bWeChangedIt;

// Index or reindex the public and secret key rings.
// Assumes key ring files are open. Index files may not
// be open if this is a new set of key rings. Returns
// TRUE if successful, and FALSE for error.
//.....................................................
BOOL IndexKeyRingFiles(HWND hParentWindow)
{
	LARGE_INTEGER	li;
	LPBYTE			lpKeyBuffer;
	LPBYTE			lpKeyBufferDup;
	DWORD			dwPacketLength;
	BOOL			bDeletePacket;
	BOOL			bRemovehHook;
	BOOL			bRemoveMouseHook;
	BOOL			bResult;
	BOOL			bFinalResult = FALSE;
	DWORD			dwBytesRead;
	DWORD			dwBytesToRead;
	DWORD			dwLengthOfLength;
	DWORD			dwBytesWritten;
	DWORD			dwCtb_Byte;
	BYTE			MaskByte;
	int				iCompareResult;

	// Always assume we do not have a universal or chat key.
	//......................................................
	bNeedUKey = TRUE;
	bNeedChatKey = TRUE;

	// We assume no individual key packet exceeds SIZE_KEY_BUFF.
	//..........................................................
	lpKeyBuffer = AllocateMemory(SIZE_KEY_BUFF);
	if (!lpKeyBuffer)
	{
		goto IndexEnd;
	}
	
	// Rewind all the files to their beginning.
	//.........................................
	bResult = RewindAllKeyRingFiles();
	if (!bResult)
	{
		goto IndexEnd;
	}

	// Clear the key ring stat variables.
	//...................................
	__asm
	{
		mov		dwPublicKeys,0h
		mov		dwPublicIds,0h
		mov		dwPublicSigs,0h
		mov		dwCompromiseSigs,0h
		mov		dwSecretKeys,0h
		mov		dwSecretIds,0h
	}

	// Setup mouse and keyboard hook procedures for this dialog box
	// so you cannot tab to the checkboxes.
	//.............................................................
	bRemovehHook = FALSE;
	bRemoveMouseHook = FALSE;
	if (!hHook)
	{
		hHook = SetWindowsHookEx(WH_KEYBOARD,(HOOKPROC)TrapTabKey,NULL,0);
		bRemovehHook = TRUE;
	}
	if (!hMouseHook)
	{
		hMouseHook = SetWindowsHookEx(WH_MOUSE,(HOOKPROC)TrapMouseInput,NULL,0);
		bRemoveMouseHook = TRUE;
	}

	// Display the modeless dialog box for indexing the key rings.
	//............................................................
	hDlgModeLess1 = CreateDialog(hInst,TEXT("INDEXKEYRINGS"),hParentWindow,
								(DLGPROC)IndexKeyRingsProc);

	if (!hDlgModeLess1)
	{
		ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
		goto IndexEnd;
	}

	EnableWindow(GetDlgItem(hDlgModeLess1,IDC_REMOVERECORDS),TRUE);

	// Check the secret key ring file first for deleted items.
	// Each packet must be separately marked as deleted. If a
	// key packet is marked as deleted, all the user id packets
	// for that key packet must be marked also.
	//.........................................................
	if (dwSecretDeleted)
	{
		// Create our backup file for the key ring.
		//.........................................
		hBackUpFile = CreateMyFile((LPTSTR)&szBackUpFile,GENERIC_READ | GENERIC_WRITE,0,
								    NULL,CREATE_NEW,FILE_ATTRIBUTE_NORMAL,NULL);
		if (!hBackUpFile)
		{
			goto IndexEnd;
		}
		// We have to process the file a packet at a time. The only
		// packets that should be in the secret key ring are secret
		// key packets and user id packets.
		//.........................................................
		while (TRUE)
		{
			// Reset the variables for this packet.
			//.....................................
			__asm
			{
				mov		bDeletePacket,FALSE
				mov		eax,lpKeyBuffer
				mov		lpKeyBufferDup,eax
			}
			// Read the CTB byte for the packet.
			//..................................
			bResult = ReadMyFile((LPTSTR)&cfg.szSecretKeyRing,hSecretKeyRing,
								  lpKeyBufferDup,1,&dwBytesRead,NULL);
			if (!bResult)
			{
				goto IndexEnd;
			}
			// If end of file break out of the loop.
			//......................................
			if (dwBytesRead == 0)
			{
				break;
			}
			__asm
			{
				mov		eax,dwBytesRead
				mov		dwPacketLength,eax

				// Check the packet type.
				//.......................
				mov		edi,lpKeyBufferDup
				mov		al,byte ptr [edi]
				mov		cl,al
				and		al,CTB_MASK
				cmp		al,CTB_SECRET_KEY
				je		L2
				cmp		al,CTB_USER_ID
				je		L2
			}
			// We encountered an invalid packet in a secret key ring.
			//.......................................................
			L1:	SetLastError(IDS_CORRUPTSECRETKEYRING);
			ErrorProcedure((LPTSTR)&cfg.szSecretKeyRing,IDS_INDEXKEYRINGS,MB_OK);
			goto IndexEnd;

			__asm
			{
				// Check for packet deletion.
				//...........................
			L2: test	cl,DELETED_BIT
				jz		L3
				mov		bDeletePacket,TRUE

				// Check the length of the length field.
				//......................................
			L3:	mov		edx,1
				and		cl,LENGTH_MASK
				shl		edx,cl
				cmp		cl,NO_LENGTH
				je		L1
				add		dwPacketLength,edx
				mov		dwBytesToRead,edx
				mov		dwLengthOfLength,edx

				// Buffer offset to read length field into.
				//.........................................
				inc		lpKeyBufferDup
			}
			// Read the length field of the packet.
			//.....................................
			bResult = ReadMyFile((LPTSTR)&cfg.szSecretKeyRing,hSecretKeyRing,
								  lpKeyBufferDup,dwBytesToRead,&dwBytesRead,NULL);
			if (!bResult)
			{
				goto IndexEnd;
			}
			if (dwBytesToRead != dwBytesRead)
			{
				goto L1;
			}
			// Check out the packet length.
			//.............................
			GetPcktLgth(lpKeyBufferDup,dwLengthOfLength);

			__asm
			{
				cmp		eax,(SIZE_KEY_BUFF-5)
				ja		L1
				add		dwPacketLength,eax

				// Buffer offset to read packet into.
				//...................................
				add		lpKeyBufferDup,edx
				mov		dwBytesToRead,eax
			}
			// Read the packet into the buffer.
			//.................................
			bResult = ReadMyFile((LPTSTR)&cfg.szSecretKeyRing,hSecretKeyRing,
								  lpKeyBufferDup,dwBytesToRead,&dwBytesRead,NULL);
			if (!bResult)
			{
				goto IndexEnd;
			}
			if (dwBytesToRead != dwBytesRead)
			{
				goto L1;
			}
			// If the packet is not marked as deleted, write it
			// to the new file.
			//.................................................
			if (!bDeletePacket)
			{
				bResult = WriteMyFile((LPTSTR)&szBackUpFile,hBackUpFile,lpKeyBuffer,
									   dwPacketLength,&dwBytesWritten,NULL);
				if (!bResult)
				{
					goto IndexEnd;
				}
			}
		}	// while (TRUE)

		// We have our new secret key ring file.
		//......................................
		bResult = CloseMyHandle((LPTSTR)&cfg.szSecretKeyRing,hSecretKeyRing);
		if (!bResult)
		{
			goto IndexEnd;
		}
		hSecretKeyRing = 0;
		dwKeyRingFilesActive--;

		bResult = DeleteMyFile((LPTSTR)&cfg.szSecretKeyRing);
		if (!bResult)
		{
			goto IndexEnd;
		}
		// Close the backup file which is the new secret key ring.
		//........................................................
		bResult = CloseMyHandle((LPTSTR)&szBackUpFile,hBackUpFile);
		if (!bResult)
		{
			goto IndexEnd;
		}
		hBackUpFile = 0;

		// Copy the backup file to our secret key ring.
		//.............................................
		bResult = CopyMyFile((LPCTSTR)&szBackUpFile,(LPCTSTR)&cfg.szSecretKeyRing,FALSE);
		if (!bResult)
		{
			goto IndexEnd;
		}
		// Delete the backup file.
		//........................
		bResult = DeleteMyFile((LPTSTR)&szBackUpFile);
		if (!bResult)
		{
			goto IndexEnd;
		}
		// Reopen the new secret key ring.
		//................................
		hSecretKeyRing = CreateMyFile((LPTSTR)&cfg.szSecretKeyRing,
									   GENERIC_READ | GENERIC_WRITE,0,NULL,OPEN_EXISTING,
									   FILE_ATTRIBUTE_NORMAL,NULL);
		if (!hSecretKeyRing)
		{
			goto IndexEnd;
		}
		dwKeyRingFilesActive++;
	}	// if (dwSecretDeleted) 

	// Now check the public key ring file for deleted packets.
	//........................................................
	if (dwPublicDeleted)
	{
		// Create our backup file for the key ring.
		//.........................................
		hBackUpFile = CreateMyFile((LPTSTR)&szBackUpFile,GENERIC_READ | GENERIC_WRITE,0,
								    NULL,CREATE_NEW,FILE_ATTRIBUTE_NORMAL,NULL);
		if (!hBackUpFile)
		{
			goto IndexEnd;
		}
		// We have to process the file a packet at a time. The only
		// packets that should be in the public key ring are public
		// key packets, user id packets, trust packets, and secret
		// key encrypted packets, ie. signatures.
		//.........................................................
		while (TRUE)
		{
			// Reset the variables for this packet.
			//.....................................
			__asm
			{
				mov		bDeletePacket,FALSE
				mov		eax,lpKeyBuffer
				mov		lpKeyBufferDup,eax
			}
			// Read the CTB byte for the packet.
			//..................................
			bResult = ReadMyFile((LPTSTR)&cfg.szPublicKeyRing,hPublicKeyRing,
								  lpKeyBufferDup,1,&dwBytesRead,NULL);
			if (!bResult)
			{
				goto IndexEnd;
			}
			// If end of file break out of the loop.
			//......................................
			if (dwBytesRead == 0)
			{
				break;
			}
			__asm
			{
				mov		eax,dwBytesRead
				mov		dwPacketLength,eax

				// Check the packet type.
				//.......................
				mov		edi,lpKeyBufferDup
				mov		al,byte ptr [edi]
				mov		cl,al
				and		al,CTB_MASK
				cmp		al,CTB_PUBLIC_KEY
				je		L5
				cmp		al,CTB_USER_ID
				je		L5
				cmp		al,CTB_SKE_PACKET
				je		L5
				cmp		al,CTB_TRUST
				je		L5
			}	
			// We encountered an invalid packet in a public key ring.
			//.......................................................
			L4:	SetLastError(IDS_CORRUPTPUBLICKEYRING);
			ErrorProcedure((LPTSTR)&cfg.szPublicKeyRing,IDS_INDEXKEYRINGS,MB_OK);
			goto IndexEnd;

			__asm
			{
				// Check for packet deletion.
				//...........................
			L5: test	cl,DELETED_BIT
				jz		L6
				mov		bDeletePacket,TRUE

				// Check the length of the length field.
				//......................................
			L6:	mov		edx,1
				and		cl,LENGTH_MASK
				shl		edx,cl
				cmp		cl,NO_LENGTH
				je		L4
				add		dwPacketLength,edx
				mov		dwBytesToRead,edx
				mov		dwLengthOfLength,edx

				// Buffer offset to read length field into.
				//.........................................
				inc		lpKeyBufferDup
			}
			// Read the length field of the packet.
			//.....................................
			bResult = ReadMyFile((LPTSTR)&cfg.szPublicKeyRing,hPublicKeyRing,
								  lpKeyBufferDup,dwBytesToRead,&dwBytesRead,NULL);
			if (!bResult)
			{
				goto IndexEnd;
			}
			if (dwBytesToRead != dwBytesRead)
			{
				goto L4;
			}
			// Check out the packet length.
			//.............................
			GetPcktLgth(lpKeyBufferDup,dwLengthOfLength);

			__asm
			{
				cmp		eax,(SIZE_KEY_BUFF-5)
				ja		L4
				add		dwPacketLength,eax

				// Buffer offset to read packet into.
				//...................................
				add		lpKeyBufferDup,edx
				mov		dwBytesToRead,eax
			}
			// Read the packet into the buffer.
			//.................................
			bResult = ReadMyFile((LPTSTR)&cfg.szPublicKeyRing,hPublicKeyRing,
								  lpKeyBufferDup,dwBytesToRead,&dwBytesRead,NULL);
			if (!bResult)
			{
				goto IndexEnd;
			}
			if (dwBytesToRead != dwBytesRead)
			{
				goto L4;
			}
			// If the packet is not marked as deleted, write it
			// to the new file.
			//.................................................
			if (!bDeletePacket)
			{
				bResult = WriteMyFile((LPTSTR)&szBackUpFile,hBackUpFile,lpKeyBuffer,
									   dwPacketLength,&dwBytesWritten,NULL);
				if (!bResult)
				{
					goto IndexEnd;
				}
			}
		}	// while (TRUE)

		// We have our new public key ring file.
		//......................................
		bResult = CloseMyHandle((LPTSTR)&cfg.szPublicKeyRing,hPublicKeyRing);
		if (!bResult)
		{
			goto IndexEnd;
		}
		hPublicKeyRing = 0;
		dwKeyRingFilesActive--;

		bResult = DeleteMyFile((LPTSTR)&cfg.szPublicKeyRing);
		if (!bResult)
		{
			goto IndexEnd;
		}
		// Close the backup file which is the new public key ring.
		//........................................................
		bResult = CloseMyHandle((LPTSTR)&szBackUpFile,hBackUpFile);
		if (!bResult)
		{
			goto IndexEnd;
		}
		hBackUpFile = 0;

		// Copy the backup file to our public key ring.
		//.............................................
		bResult = CopyMyFile((LPCTSTR)&szBackUpFile,(LPCTSTR)&cfg.szPublicKeyRing,FALSE);
		if (!bResult)
		{
			goto IndexEnd;
		}
		// Delete the backup file.
		//........................
		bResult = DeleteMyFile((LPTSTR)&szBackUpFile);
		if (!bResult)
		{
			goto IndexEnd;
		}
		// Reopen the new public key ring.
		//................................
		hPublicKeyRing = CreateMyFile((LPTSTR)&cfg.szPublicKeyRing,GENERIC_READ | GENERIC_WRITE,
									   0,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
		if (!hPublicKeyRing)
		{
			goto IndexEnd;
		}
		dwKeyRingFilesActive++;
	}	// if (dwPublicDeleted)

	CheckDlgButton(hDlgModeLess1,IDC_REMOVERECORDS,BST_CHECKED);
	EnableWindow(GetDlgItem(hDlgModeLess1,IDC_DELETEINDEX),TRUE);

	// Close and delete the old index files if they are present.
	//..........................................................
	if (hPublicRingKeyId)
	{
		bResult = CloseMyHandle(szPublicRingKeyId,hPublicRingKeyId);
		if (!bResult)
		{
			goto IndexEnd;
		}
		hPublicRingKeyId = 0;
		dwKeyRingFilesActive--;

		bResult = DeleteMyFile(szPublicRingKeyId);
		if (!bResult)
		{
			goto IndexEnd;
		}
	}
	if (hPublicRingUserId)
	{
		bResult = CloseMyHandle(szPublicRingUserId,hPublicRingUserId);
		if (!bResult)
		{
			goto IndexEnd;
		}
		hPublicRingUserId = 0;
		dwKeyRingFilesActive--;

		bResult = DeleteMyFile(szPublicRingUserId);
		if (!bResult)
		{
			goto IndexEnd;
		}
	}
	if (hSecretRingKeyId)
	{
		bResult = CloseMyHandle(szSecretRingKeyId,hSecretRingKeyId);
		if (!bResult)
		{
			goto IndexEnd;
		}
		hSecretRingKeyId = 0;
		dwKeyRingFilesActive--;

		bResult = DeleteMyFile(szSecretRingKeyId);
		if (!bResult)
		{
			goto IndexEnd;
		}
	}
	if (hSecretRingUserId)
	{
		bResult = CloseMyHandle(szSecretRingUserId,hSecretRingUserId);
		if (!bResult)
		{
			goto IndexEnd;
		}
		hSecretRingUserId = 0;
		dwKeyRingFilesActive--;

		bResult = DeleteMyFile(szSecretRingUserId);
		if (!bResult)
		{
			goto IndexEnd;
		}
	}
	// Create new index files.
	//........................
	hPublicRingKeyId = CreateMyFile((LPTSTR)&szPublicRingKeyId,GENERIC_READ |GENERIC_WRITE,
									 0,NULL,CREATE_NEW,FILE_ATTRIBUTE_NORMAL,NULL);
	if (!hPublicRingKeyId)
	{
		goto IndexEnd;
	}
	dwKeyRingFilesActive++;

	hPublicRingUserId = CreateMyFile((LPTSTR)&szPublicRingUserId,GENERIC_READ |GENERIC_WRITE,
									  0,NULL,CREATE_NEW,FILE_ATTRIBUTE_NORMAL,NULL);
	if (!hPublicRingUserId)
	{
		goto IndexEnd;
	}
	dwKeyRingFilesActive++;

	hSecretRingKeyId = CreateMyFile((LPTSTR)&szSecretRingKeyId,GENERIC_READ |GENERIC_WRITE,
								     0,NULL,CREATE_NEW,FILE_ATTRIBUTE_NORMAL,NULL);
	if (!hSecretRingKeyId)
	{
		goto IndexEnd;
	}
	dwKeyRingFilesActive++;

	hSecretRingUserId = CreateMyFile((LPTSTR)&szSecretRingUserId,GENERIC_READ |GENERIC_WRITE,
									  0,NULL,CREATE_NEW,FILE_ATTRIBUTE_NORMAL,NULL);
	if (!hSecretRingUserId)
	{
		goto IndexEnd;
	}
	dwKeyRingFilesActive++;

	CheckDlgButton(hDlgModeLess1,IDC_DELETEINDEX,BST_CHECKED);
	EnableWindow(GetDlgItem(hDlgModeLess1,IDC_CREATEINDEX),TRUE);

	// We will process the secret key ring first. There can only be
	// one key id, but there can be more than one user id per secret
	// key.
	//..............................................................

	// Set the initial file pointer to 0.
	//...................................
	dwSecretFilePosition = 0;

	while (TRUE)
	{
		dwPacketLength = 0;
		UserIdIndex1.FILE_POS = dwSecretFilePosition;
		KeyIdIndex1.FILE_POS = dwSecretFilePosition;
		ZeroMemory(lpKeyBuffer,SIZE_KEY_BUFF);
		lpKeyBufferDup = lpKeyBuffer;

		// Read a section of the file. We assume that the total length
		// of any secret key plus user id's is less than SIZE_KEY_BUFF.
		//.............................................................
		bResult = ReadMyFile((LPTSTR)&cfg.szSecretKeyRing,hSecretKeyRing,
							  lpKeyBuffer,SIZE_KEY_BUFF,&dwBytesRead,NULL);
		if (!bResult)
		{
			goto IndexEnd;
		}
		if (dwBytesRead == 0)	// End of file.
		{
			break;
		}
		_asm
		{
			mov		edi,lpKeyBufferDup
			mov		al,byte ptr [edi]
			mov		cl,al
			and		al,CTB_MASK

			// First byte should be CTB for secret key certificate.
			//.....................................................
			cmp		al,CTB_SECRET_KEY
			jne		L1

			// Add 1 to the number of secret keys.
			//....................................
			inc		dwSecretKeys

			// Get past the CTB field.
			//........................
			add		dwPacketLength,CTB_SIZE
			mov		dwCtb_Byte,ecx
		}
		// Get the packet length.
		//.......................
		GetPcktLength(lpKeyBufferDup,dwCtb_Byte);

		__asm
		{
			mov		edi,lpKeyBufferDup
			add		edi,CTB_SIZE

			// Add in the length of the length field and secret
			// key packet.
			//.................................................
			add		dwPacketLength,edx
			add		dwPacketLength,eax

			// Add length field size to edi.
			//..............................
			add		edi,edx

			// Lets get our 64 bit key id before we look at user ids.
			// We have to get by the version, timestamp, validity and
			// algorithm fields.
			//.......................................................
			add		edi,(VERSION_SIZE+TIMESTAMP_SIZE+VALIDITY_SIZE+ALGORITHM_SIZE)
			movzx	eax,word ptr [edi]
			xchg	ah,al
			add		eax,7
			shr		eax,3
			add		edi,MPI_PREFIX_SIZE
			sub		eax,KEY_ID_SIZE
			add		edi,eax
			mov		eax,dword ptr [edi]		// msd
			mov		KeyIdIndex1.KEY_ID,eax
			mov		UserIdIndex1.KEY_ID,eax
			mov		eax,dword ptr [edi+4]	// lsd
			mov		KeyIdIndex1.KEY_ID[4],eax
			mov		UserIdIndex1.KEY_ID[4],eax

			// Now we look at user ids. There can be more than one.
			// This is to get the total length of the secret key
			// plus user ids. Set edi to start of user ids.
			//.....................................................
			mov		edi,lpKeyBufferDup
			add		edi,dwPacketLength
			mov		lpKeyBufferDup,edi
			push	edi

		L7:	mov		al,byte ptr [edi]
			mov		cl,al
			and		al,CTB_MASK
			cmp		al,CTB_USER_ID
			jne		L8

			// Add 1 to number of secret user ids.
			//....................................
			inc		dwSecretIds
			add		dwPacketLength,CTB_SIZE
			mov		dwCtb_Byte,ecx
		}
		// Get the packet length.
		//.......................
		GetPcktLength(lpKeyBufferDup,dwCtb_Byte);

		__asm
		{
			mov		edi,lpKeyBufferDup
			add		edi,CTB_SIZE

			// Add in the length of the length field and user id packet.
			//..........................................................
			add		dwPacketLength,edx
			add		dwPacketLength,eax
			add		edi,edx
			add		edi,eax
			mov		lpKeyBufferDup,edi
			jmp		L7

			// Total length of the secret key plus user ids is in
			// dwPacketLength.
			//...................................................
		L8: mov		eax,dwPacketLength
			mov		KeyIdIndex1.TOTAL_LENGTH,eax
			mov		UserIdIndex1.TOTAL_LENGTH,eax

			// Address of first user id in edi. Save in lpKeyBufferDup.
			//.........................................................
			pop		edi
			mov		lpKeyBufferDup,edi
		}
		// Write the key id index first.
		//..............................
		bResult = WriteMyFile((LPTSTR)&szSecretRingKeyId,hSecretRingKeyId,
							   &KeyIdIndex1,sizeof(K_IDX_FMT),&dwBytesWritten,NULL);
		if (!bResult)
		{
			goto IndexEnd;
		}
		// Now for the user ids.
		//......................
		while (TRUE)
		{
			ZeroMemory(&UserIdIndex1.USER_ID,sizeof(UserIdIndex1.USER_ID));
			__asm
			{
				mov		edi,lpKeyBufferDup
				mov		al,byte ptr [edi]
				mov		cl,al
				mov		dwCtb_Byte,ecx
				and		al,CTB_MASK
				mov		MaskByte,al
			}
			if (MaskByte != CTB_USER_ID)
			{
				break;
			}
			GetPcktLength(lpKeyBufferDup,dwCtb_Byte);

			__asm
			{
				// Get past the length field. Length of user id in eax.
				//.....................................................
				mov		edi,lpKeyBufferDup
				add		edi,CTB_SIZE
				add		edi,edx
				
				// If the user id is too large, we have an error.
				//...............................................
				cmp		eax,MAX_USER_ID
				ja		L1

				// Save user id address and length on the stack.
				//..............................................
				push	edi
				push	eax

				// Copy the user id to the index record.
				//......................................
				mov		esi,edi
				mov		ecx,eax
				mov		edi,offset UserIdIndex1[16]
				rep		movsb
				pop		eax
				pop		edi
				add		edi,eax
				mov		lpKeyBufferDup,edi
			}
			// Write the index record to disk.
			//................................
			bResult = WriteMyFile((LPTSTR)&szSecretRingUserId,hSecretRingUserId,&UserIdIndex1,
								   sizeof(U_IDX_FMT),&dwBytesWritten,NULL);
			if (!bResult)
			{
				goto IndexEnd;
			}
		}	// while (TRUE)

		// Position the file pointer to point to the next secret key.
		//...........................................................
		dwSecretFilePosition += UserIdIndex1.TOTAL_LENGTH;
		li.QuadPart = 0;
		li.LowPart = dwSecretFilePosition;
		li.QuadPart = SetMyFilePointer((LPTSTR)&cfg.szSecretKeyRing,hSecretKeyRing,
									    li.QuadPart,FILE_BEGIN);
		if (li.QuadPart == -1)
		{
			goto L1;
		}
	}	// while (TRUE)

	// Process the public key ring. Set the initial file pointer to 0.
	//................................................................
	dwPublicFilePosition = 0;

	while (TRUE)
	{
		dwPacketLength = 0;
		UserIdIndex1.FILE_POS = dwPublicFilePosition;
		KeyIdIndex1.FILE_POS = dwPublicFilePosition;
		ZeroMemory(lpKeyBuffer,SIZE_KEY_BUFF);
		lpKeyBufferDup = lpKeyBuffer;

		// Read a section of the file. We assume that the total length
		// of any public key plus user id's, etc., is less than 
		// SIZE_KEY_BUFF.
		//.............................................................
		bResult = ReadMyFile((LPTSTR)&cfg.szPublicKeyRing,hPublicKeyRing,
							  lpKeyBuffer,SIZE_KEY_BUFF,&dwBytesRead,NULL);
		if (!bResult)
		{
			goto IndexEnd;
		}
		if (dwBytesRead == 0)	// End of file.
		{
			break;
		}
		_asm
		{
			mov		edi,lpKeyBufferDup
			mov		al,byte ptr [edi]
			mov		cl,al
			and		al,CTB_MASK

			// First byte should be CTB for public key certificate.
			//.....................................................
			cmp		al,CTB_PUBLIC_KEY
			jne		L4

			// Add 1 to the number of public keys.
			//....................................
			inc		dwPublicKeys

			// Get past the CTB field.
			//........................
			add		dwPacketLength,CTB_SIZE
			mov		dwCtb_Byte,ecx
		}
		// Get the packet length.
		//.......................
		GetPcktLength(lpKeyBufferDup,dwCtb_Byte);

		__asm
		{
			mov		edi,lpKeyBufferDup
			add		edi,CTB_SIZE

			// Add in the length of the length field and secret
			// key packet.
			//.................................................
			add		dwPacketLength,edx
			add		dwPacketLength,eax

			// Add length field size to edi.
			//..............................
			add		edi,edx

			// Lets get our 64 bit key id before we look at trust
			// bytes, user ids, and signature packets. We have to
			// get by the version, timestamp, validity and algorithm
			// fields.
			//......................................................
			add		edi,(VERSION_SIZE+TIMESTAMP_SIZE+VALIDITY_SIZE+ALGORITHM_SIZE)
			movzx	eax,word ptr [edi]
			xchg	ah,al
			add		eax,7
			shr		eax,3
			add		edi,MPI_PREFIX_SIZE
			sub		eax,KEY_ID_SIZE
			add		edi,eax
			mov		eax,dword ptr [edi]		// msd
			mov		KeyIdIndex1.KEY_ID,eax
			mov		UserIdIndex1.KEY_ID,eax
			mov		eax,dword ptr [edi+4]	// lsd
			mov		KeyIdIndex1.KEY_ID[4],eax
			mov		UserIdIndex1.KEY_ID[4],eax

			// The next field should be a trust packet for the key
			// followed by an number of user ids and signatures. 
			// Each user id and signature will have its own trust
			// packet. We will never have any comment or literal
			// packets in our public key ring. The following finds
			// the total length of the complete public key.
			//....................................................
			mov		edi,lpKeyBufferDup
			add		edi,dwPacketLength
			mov		lpKeyBufferDup,edi
			push	edi

		L9:	mov		al,byte ptr [edi]
			mov		cl,al
			and		al,CTB_MASK
			cmp		al,CTB_TRUST
			je		L10
			cmp		al,CTB_USER_ID
			je		L10
			cmp		al,CTB_SKE_PACKET
			jne		L13

			// Add 1 to public key user ids or signatures depending
			// on type of packet.
			//.....................................................
	   L10:	cmp		al,CTB_USER_ID
			jne		L11
			inc		dwPublicIds
			jmp		L12
	   L11:	cmp		al,CTB_SKE_PACKET
			jne		L12
			inc		dwPublicSigs

			// See if this is a compromise certificate.
			//.........................................
			cmp		byte ptr [edi+5],KEY_COMPROMISE
			jne		L12
			inc		dwCompromiseSigs

	   L12:	add		dwPacketLength,CTB_SIZE
			mov		dwCtb_Byte,ecx
		}
		// Get the packet length.
		//.......................
		GetPcktLength(lpKeyBufferDup,dwCtb_Byte);

		__asm
		{
			mov		edi,lpKeyBufferDup
			add		edi,CTB_SIZE

			// Add in the length of the length field and user id packet.
			//..........................................................
			add		dwPacketLength,edx
			add		dwPacketLength,eax
			add		edi,edx
			add		edi,eax
			mov		lpKeyBufferDup,edi
			jmp		L9

			// Total length of the public key plus user ids, etc.,
			// is in dwPacketLength.
			//....................................................
	   L13: mov		eax,dwPacketLength
			mov		KeyIdIndex1.TOTAL_LENGTH,eax
			mov		UserIdIndex1.TOTAL_LENGTH,eax

			// Address of first packet after key in edi. Save in
			// lpKeyBufferDup.
			//..................................................
			pop		edi
			mov		lpKeyBufferDup,edi
		}
		// Write the key id index first.
		//..............................
		bResult = WriteMyFile((LPTSTR)&szPublicRingKeyId,hPublicRingKeyId,
							   &KeyIdIndex1,sizeof(K_IDX_FMT),&dwBytesWritten,NULL);
		if (!bResult)
		{
			goto IndexEnd;
		}
		// Check to see if this is the universal key.
		//...........................................
		iCompareResult = CompareString(LOCALE_USER_DEFAULT,0,(LPCTSTR)&cfg.V1.V2,KEY_ID_SIZE,
									  (LPCTSTR)&KeyIdIndex1.KEY_ID,KEY_ID_SIZE);
		if (iCompareResult == CSTR_EQUAL)
		{
			bNeedUKey = FALSE;
		}
		// Check to see if this is the chat key.
		//......................................
		iCompareResult = CompareString(LOCALE_USER_DEFAULT,0,(LPCTSTR)&cfg.cp.ChatKey,
									   KEY_ID_SIZE,(LPCTSTR)&KeyIdIndex1.KEY_ID,KEY_ID_SIZE);
		if (iCompareResult == CSTR_EQUAL)
		{
			bNeedChatKey = FALSE;
		}
		// Now for the user ids.
		//......................
		while (TRUE)
		{
			ZeroMemory(&UserIdIndex1.USER_ID,sizeof(UserIdIndex1.USER_ID));
			__asm
			{
				mov		edi,lpKeyBufferDup
				mov		al,byte ptr [edi]
				mov		cl,al
				mov		dwCtb_Byte,ecx
				and		al,CTB_MASK
				mov		MaskByte,al
			}

			// At the end of the user ids and trust packets for this
			// public key if we find the next public key or a null byte.
			//..........................................................
			if (MaskByte == CTB_PUBLIC_KEY || MaskByte == 0)
			{
				break;
			}
			GetPcktLength(lpKeyBufferDup,dwCtb_Byte);

			__asm
			{
				// Get past the length field. Length of user id in eax.
				//.....................................................
				mov		edi,lpKeyBufferDup
				add		edi,CTB_SIZE
				add		edi,edx
				
				// Setup address of next packet in lpKeyBufferDup.
				//................................................
				mov		edx,edi
				add		edx,eax
				mov		lpKeyBufferDup,edx

				// If this is a user id save it and write the index
				// record to disk.
				//.................................................
				cmp		MaskByte,CTB_USER_ID
				jne		L14

				// If the user id is too large, we have an error.
				//...............................................
				cmp		eax,MAX_USER_ID
				ja		L4

				// Copy the user id to the index record.
				//......................................
				mov		esi,edi
				mov		ecx,eax
				mov		edi,offset UserIdIndex1[16]
				rep		movsb
			}
			// Write the index record to disk.
			//................................
			bResult = WriteMyFile((LPTSTR)&szPublicRingUserId,hPublicRingUserId,&UserIdIndex1,
								   sizeof(U_IDX_FMT),&dwBytesWritten,NULL);
			if (!bResult)
			{
				goto IndexEnd;
			}
		L14:;
		}	// while (TRUE)

		// Position the file pointer to point to the next public key.
		//...........................................................
		dwPublicFilePosition += UserIdIndex1.TOTAL_LENGTH;
		li.QuadPart = 0;
		li.LowPart = dwPublicFilePosition;
		li.QuadPart = SetMyFilePointer((LPTSTR)&cfg.szPublicKeyRing,hPublicKeyRing,li.QuadPart,
									    FILE_BEGIN);
		if (li.QuadPart == -1)
		{
			goto L1;
		}
	}	// while (TRUE)

	CheckDlgButton(hDlgModeLess1,IDC_CREATEINDEX,BST_CHECKED);
	EnableWindow(GetDlgItem(hDlgModeLess1,IDC_SORTPUBKEYID),TRUE);

	// Flush all file buffers to disk.
	//................................
	bResult = FlushAllFiles();
	if (!bResult)
	{
		goto IndexEnd;
	}

	// We have to sort the index files. They will be sorted in 
	// memory if we have enough, else they will be sorted on disk.
	//............................................................
	bResult = SortMyFile((LPTSTR)&szPublicRingKeyId,hPublicRingKeyId,0,&KeyIdSort,ASCENDING);
	if (!bResult)
	{
		goto IndexEnd;
	}

	CheckDlgButton(hDlgModeLess1,IDC_SORTPUBKEYID,BST_CHECKED);
	EnableWindow(GetDlgItem(hDlgModeLess1,IDC_SORTPUBUSERID),TRUE);

	bResult = SortMyFile((LPTSTR)&szPublicRingUserId,
		                        hPublicRingUserId,0,&UserIdSort,ASCENDING);
	if (!bResult)
	{
		goto IndexEnd;
	}

	CheckDlgButton(hDlgModeLess1,IDC_SORTPUBUSERID,BST_CHECKED);
	EnableWindow(GetDlgItem(hDlgModeLess1,IDC_SORTSECKEYID),TRUE);

	bResult = SortMyFile((LPTSTR)&szSecretRingKeyId,hSecretRingKeyId,0,&KeyIdSort,ASCENDING);
	if (!bResult)
	{
		goto IndexEnd;
	}

	CheckDlgButton(hDlgModeLess1,IDC_SORTSECKEYID,BST_CHECKED);
	EnableWindow(GetDlgItem(hDlgModeLess1,IDC_SORTSECUSERID),TRUE);

	bResult = SortMyFile((LPTSTR)&szSecretRingUserId,
		                        hSecretRingUserId,0,&UserIdSort,ASCENDING);
	if (!bResult)
	{
		goto IndexEnd;
	}

	CheckDlgButton(hDlgModeLess1,IDC_SORTSECUSERID,BST_CHECKED);

	// Flush all the file buffers again.
	//..................................
	bResult = FlushAllFiles();
	if (!bResult)
	{
		goto IndexEnd;
	}

	// Check for zero length key ring files. If we find a 0 length
	// public or secret key ring, we close them all and return FALSE.
	//...............................................................
	bResult = CheckForZeroLengthFiles();
	if (!bResult)
	{
		goto IndexEnd;
	}

	// Rewind all the files.
	//......................
	bResult = RewindAllKeyRingFiles();

	// Put in a small delay for small files.
	//......................................
	Sleep(1000);

	bFinalResult = TRUE;

	// Cleanup after ourselves. First remove our hooks.
	//.................................................
	IndexEnd:
	if (bRemovehHook)
	{
		UnhookWindowsHookEx(hHook);
		hHook = 0;
	}
	if (bRemoveMouseHook)
	{
		UnhookWindowsHookEx(hMouseHook);
		hMouseHook = 0;
	}

	if (hDlgModeLess1)
	{
		DestroyWindow(hDlgModeLess1);
	}

	// Deallocate the memory we used.
	//...............................
	if (lpKeyBuffer)
	{
		ZeroMemory(lpKeyBuffer,SIZE_KEY_BUFF);
		DeallocateMemory(lpKeyBuffer);
	}
	return(bFinalResult);
}

// CALLBACK procedure for the Index Key Rings dialog box.
//.......................................................
LRESULT CALLBACK IndexKeyRingsProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);
			
			// Center the window.
			//...................
			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			return(FALSE);
		}

		case WM_ACTIVATE:
		{
			if (wParam == 0)
			{
				hDlgCurrent = NULL;
			}
			else
			{
				hDlgCurrent = hDlg;
			}
			return(FALSE);
		}

		case WM_DESTROY:
		{
			hDlgModeLess1 = NULL;
		}
		break;

		case WM_CLOSE:
			break;

		default:
			return(FALSE);
	}
	return(TRUE);
}

// GetPcktLength puts the length of the packet in eax
// depending on the size of the length field.
//
// Exit:  eax = length of packet.
//        edx = length of length field.
//...................................................
VOID GetPcktLength(LPBYTE lpBuffer, DWORD dwCtb_Byte)
{
	__asm
	{
		mov		edi,lpBuffer
		mov		ecx,dwCtb_Byte
		mov		edx,1
		and		cl,LENGTH_MASK
		shl		edx,cl
		add		edi,CTB_SIZE
		cmp		edx,1
		jne		L1
		movzx	eax,byte ptr [edi]
		jmp		L3
	L1:	cmp		edx,2
		jne		L2
		movzx	eax,word ptr [edi]
		xchg	ah,al
		jmp		L3
	L2:	mov		eax,dword ptr [edi]
		bswap	eax
	L3:
	}
}

// Return the length of the packet in eax.
//
// Exit:  eax = length of packet. 
//........................................
VOID GetPcktLgth(LPBYTE lpBuffer, DWORD dwSizeOfLengthField)
{
	__asm
	{
		mov		edi,lpBuffer
		mov		edx,dwSizeOfLengthField
		cmp		edx,1
		jne		L1
		movzx	eax,byte ptr [edi]
		jmp		L3
	L1:	cmp		edx,2
		jne		L2
		movzx	eax,word ptr [edi]
		xchg	ah,al
		jmp		L3
	L2:	mov		eax,dword ptr [edi]
		bswap	eax
	L3:
	}
}

// Check for 0 length key ring files. If we find one, close and 
// delete it, and close and delete all index files. Returns 
// FALSE if we had a 0 length key ring file or disk error, in
// which case all the files will be closed. Returns TRUE if
// no 0 length key ring file.
//.............................................................
BOOL CheckForZeroLengthFiles()
{
	ULARGE_INTEGER	liPub;
	ULARGE_INTEGER	liSec;
	BOOL			bResult= FALSE;

	// Check out the public key ring first.
	//.....................................
	liPub.QuadPart = GetMyFileSize(cfg.szPublicKeyRing,hPublicKeyRing);
	if(liPub.QuadPart == -1)
	{
		CloseAllKeyRingFiles();
		goto CheckEnd;
	}

	// Get the size of the secret key ring.
	//.....................................
	liSec.QuadPart = GetMyFileSize(cfg.szSecretKeyRing,hSecretKeyRing);
	if (liSec.QuadPart == -1)
	{
		CloseAllKeyRingFiles();
		goto CheckEnd;
	}

	// If either the public or secret key ring has a length of 0,
	// we close and delete it and all the index files.
	//...........................................................
	if (liPub.QuadPart == 0 || liSec.QuadPart == 0)
	{
		bResult = CloseAllKeyRingFiles();
		if (!bResult)
		{
			goto CheckEnd;
		}
		// Delete the public or secret key ring file, or both, if they
		// are of 0 length.
		//............................................................
		if (liPub.QuadPart == 0)
		{
			bResult = DeleteMyFile(cfg.szPublicKeyRing);
			if (!bResult)
			{
				goto CheckEnd;
			}
		}
		if (liSec.QuadPart == 0)
		{
			bResult = DeleteMyFile(cfg.szSecretKeyRing);
			if (!bResult)
			{
				goto CheckEnd;
			}
		}
		bResult = FALSE;
	}
	else
	{
		bResult = TRUE;
	}

	CheckEnd:
	return(bResult);
}

// Setup Group One or Two variables for use by
// various procedures.
//............................................
VOID SetUpGroup(DWORD dwKeyType, DWORD dwIndexType, DWORD dwGroup)
{
	LARGE_INTEGER	li;
	HANDLE			hTempEAX;
	HANDLE			hTempEBX;
	LPBYTE			lpTempECX;
	LPBYTE			lpTempEDX;
	LPVOID			lpTempESI;
	DWORD			dwTempEDI;

	if (dwKeyType == PUBLIC_KEY)
	{
		hTempEBX = hPublicKeyRing;
		lpTempECX = (LPBYTE)&cfg.szPublicKeyRing;

		if (dwIndexType == INDEX_KEY)
		{
			hTempEAX = hPublicRingKeyId;
			lpTempEDX = (LPBYTE)&szPublicRingKeyId;
			lpTempESI = (LPK_IDX_FMT)lpKeyIdBuffer1;
			dwTempEDI = sizeof(K_IDX_FMT);
		}
		else
		{
			hTempEAX = hPublicRingUserId;
			lpTempEDX = (LPBYTE)&szPublicRingUserId;
			lpTempESI = (LPU_IDX_FMT)lpUserIdBuffer1;
			dwTempEDI = sizeof(U_IDX_FMT);
		}
	}
	else
	{
		hTempEBX = hSecretKeyRing;
		lpTempECX = (LPBYTE)&cfg.szSecretKeyRing;

		if (dwIndexType == INDEX_KEY)
		{
			hTempEAX = hSecretRingKeyId;
			lpTempEDX = (LPBYTE)&szSecretRingKeyId;
			lpTempESI = (LPK_IDX_FMT)lpKeyIdBuffer1;
			dwTempEDI = sizeof(K_IDX_FMT);
		}
		else
		{
			hTempEAX = hSecretRingUserId;
			lpTempEDX = (LPBYTE)&szSecretRingUserId;
			lpTempESI = (LPU_IDX_FMT)lpUserIdBuffer1;
			dwTempEDI = sizeof(U_IDX_FMT);
		}
	}

	// Put all the variables in the correct group.
	//............................................
	if (dwGroup == GROUP_ONE)
	{
		hIdxHandle1 = hTempEAX;
		hKeyHandle1 = hTempEBX;
		lpRingFile1 = lpTempECX;
		lpIndexFile1 = lpTempEDX;
		lpIdxBuffer1 = lpTempESI;
		dwIdxSize1 = dwTempEDI;
		dwIdxOffset1 = 0;

		// Determine the end of the index file.
		//.....................................
		li.QuadPart = SetMyFilePointer(lpIndexFile1,hIdxHandle1,0,FILE_END);
		dwEndIdxOffset1 = li.LowPart;
	}
	else
	{
		hIdxHandle2 = hTempEAX;
		hKeyHandle2 = hTempEBX;
		lpRingFile2 = lpTempECX;
		lpIndexFile2 = lpTempEDX;
		lpIdxBuffer2 = lpTempESI;
		dwIdxSize2 = dwTempEDI;
		dwIdxOffset2 = 0;

		// Determine the end of the index file.
		//.....................................
		li.QuadPart = SetMyFilePointer(lpIndexFile2,hIdxHandle2,0,FILE_END);
		dwEndIdxOffset2 = li.LowPart;
	}
}

// Read one key from a public or secret key ring into
// memory in lpKeyBuffer1. Returns -1 if error, else
// the number of bytes read.
//...................................................
DWORD ReadRecord1()
{
	LARGE_INTEGER	li;
	BOOL			bResult;
	DWORD			dwBytesRead;
	DWORD			dwResult = -1;

	// Setup to read the record. It does not matter which index
	// format we use since they both have the same format for the
	// file position and record length.
	//...........................................................
	dwRingFileOffset1 = ((LPU_IDX_FMT)lpIdxBuffer1)->FILE_POS;
	dwRecordLength1 = ((LPU_IDX_FMT)lpIdxBuffer1)->TOTAL_LENGTH;

	// Set the file pointer to read the key from.
	//...........................................
	li.QuadPart = 0;
	li.LowPart = dwRingFileOffset1;
	li.QuadPart = SetMyFilePointer(lpRingFile1,hKeyHandle1,li.QuadPart,FILE_BEGIN);
	if (li.QuadPart == -1)
	{
		goto Read1End;
	}

	// Zero out the buffer we will read the key into.
	//...............................................
	ZeroMemory(lpKeyBuffer1,SIZE_KEY_BUFF);

	// Read the record.
	//.................
	bResult = ReadMyFile(lpRingFile1,hKeyHandle1,lpKeyBuffer1,dwRecordLength1,
						 &dwBytesRead,NULL);
	if (!bResult)
	{
		goto Read1End;
	}
	if (dwBytesRead && dwBytesRead < dwRecordLength1)
	{
		SetLastError(IDS_PREMATUREEOF);
		ErrorProcedure(lpRingFile1,IDS_READ,MB_OK);
		goto Read1End;
	}
	dwResult = dwBytesRead;

	Read1End:
	return(dwResult);
}

// Read one key from a public or secret key ring into
// memory in lpKeyBuffer2. Returns -1 if error, else
// the number of bytes read.
//...................................................
DWORD ReadRecord2()
{
	LARGE_INTEGER	li;
	BOOL			bResult;
	DWORD			dwBytesRead;
	DWORD			dwResult = -1;

	// Setup to read the record. It does not matter which index
	// format we use since they both have the same format for the
	// file position and record length.
	//...........................................................
	dwRingFileOffset2 = ((LPU_IDX_FMT)lpIdxBuffer2)->FILE_POS;
	dwRecordLength2 = ((LPU_IDX_FMT)lpIdxBuffer2)->TOTAL_LENGTH;

	// Set the file pointer to read the key from.
	//...........................................
	li.QuadPart = 0;
	li.LowPart = dwRingFileOffset2;
	li.QuadPart = SetMyFilePointer(lpRingFile2,hKeyHandle2,li.QuadPart,FILE_BEGIN);
	if (li.QuadPart == -1)
	{
		goto Read2End;
	}

	// Zero out the buffer we will read the key into.
	//...............................................
	ZeroMemory(lpKeyBuffer2,SIZE_KEY_BUFF);

	// Read the record.
	//.................
	bResult = ReadMyFile(lpRingFile2,hKeyHandle2,lpKeyBuffer2,
						 dwRecordLength2,&dwBytesRead,NULL);
	if (!bResult)
	{
		goto Read2End;
	}
	if (dwBytesRead && dwBytesRead < dwRecordLength2)
	{
		SetLastError(IDS_PREMATUREEOF);
		ErrorProcedure(lpRingFile2,IDS_READ,MB_OK);
		goto Read2End;
	}
	dwResult = dwBytesRead;

	Read2End:
	return(dwResult);
}

// Write 1 key from lpKeyBuffer1 into a public or secret key ring.
// Returns FALSE if error.
//................................................................
BOOL WriteRecord1()
{
	LARGE_INTEGER	li;
	BOOL			bResult;
	DWORD			dwBytesWritten;

	li.QuadPart = 0;
	li.LowPart = dwRingFileOffset1;
	li.QuadPart = SetMyFilePointer(lpRingFile1,hKeyHandle1,li.QuadPart,FILE_BEGIN);
	if (li.QuadPart == -1)
	{
		bResult = FALSE;
		goto Write1End;
	}
	bResult = WriteMyFile(lpRingFile1,hKeyHandle1,lpKeyBuffer1,
						  dwRecordLength1,&dwBytesWritten,NULL);
	Write1End:
	return(bResult);
}

// Write 1 key from lpKeyBuffer2 into a public or secret key ring.
// Returns FALSE if error.
//................................................................
BOOL WriteRecord2()
{
	LARGE_INTEGER	li;
	BOOL			bResult;
	DWORD			dwBytesWritten;

	li.QuadPart = 0;
	li.LowPart = dwRingFileOffset2;
	li.QuadPart = SetMyFilePointer(lpRingFile2,hKeyHandle2,li.QuadPart,FILE_BEGIN);
	if (li.QuadPart == -1)
	{
		bResult = FALSE;
		goto Write2End;
	}
	bResult = WriteMyFile(lpRingFile2,hKeyHandle2,lpKeyBuffer2,
						  dwRecordLength2,&dwBytesWritten,NULL);
	Write2End:
	return(bResult);
}

// Read one record from an index file into memory.
// Return -1 if we have an error, else the number
// of bytes read.
//................................................
DWORD ReadIndex1()
{
	LARGE_INTEGER	li;
	BOOL			bResult;
	DWORD			dwBytesRead;
	DWORD			dwResult = -1;

	li.QuadPart = 0;
	li.LowPart = dwIdxOffset1;
	li.QuadPart = SetMyFilePointer(lpIndexFile1,hIdxHandle1,li.QuadPart,FILE_BEGIN);
	if (li.QuadPart == -1)
	{
		goto ReadIdx1End;
	}
	bResult = ReadMyFile(lpIndexFile1,hIdxHandle1,lpIdxBuffer1,dwIdxSize1,&dwBytesRead,NULL);
	if (!bResult)
	{
		goto ReadIdx1End;
	}
	if (dwBytesRead && dwBytesRead < dwIdxSize1)
	{
		SetLastError(IDS_PREMATUREEOF);
		ErrorProcedure(lpIndexFile1,IDS_READ,MB_OK);
	}
	dwResult = dwBytesRead;

	ReadIdx1End:
	return(dwResult);
}

// Read one record from an index file into memory.
// Return -1 if we have an error, else return value
// is number of bytes read.
//................................................
DWORD ReadIndex2()
{
	LARGE_INTEGER	li;
	BOOL			bResult;
	DWORD			dwBytesRead;
	DWORD			dwResult = -1;

	li.QuadPart = 0;
	li.LowPart = dwIdxOffset2;
	li.QuadPart = SetMyFilePointer(lpIndexFile2,hIdxHandle2,li.QuadPart,FILE_BEGIN);
	if (li.QuadPart == -1)
	{
		goto ReadIdx2End;
	}
	bResult = ReadMyFile(lpIndexFile2,hIdxHandle2,lpIdxBuffer2,dwIdxSize2,&dwBytesRead,NULL);
	if (!bResult)
	{
		goto ReadIdx2End;
	}
	if (dwBytesRead && dwBytesRead < dwIdxSize2)
	{
		SetLastError(IDS_PREMATUREEOF);
		ErrorProcedure(lpIndexFile2,IDS_READ,MB_OK);
		goto ReadIdx2End;
	}
	dwResult = dwBytesRead;

	ReadIdx2End:
	return(dwResult);
}

// Set or edit the owner trust byte on a public key. We do not
// set or edit buckstop keys.
//
// Entry: Public key in lpKeyBuffer1.
//
// Exit: Returns FALSE if error.
//............................................................
BOOL SetTheOwnerTrustByte(DWORD dwOperation)
{
	int			iDlgResult;
	LPBYTE		lpOwnerTrustByte;
	DWORD		dwCtb_Byte;
	DWORD		dwOldHelpTopic;
	BOOL		bResult;
	BOOL		bCurrentTabKeySetting;
	BOOL		bFinalResult = FALSE;
	BYTE		TrustByte;
	BYTE		TempCL;

	// Get the current setting.
	//.........................
	bCurrentTabKeySetting = bTrapTheTabKey;

	if (dwOperation == SET_OWNER_TRUST)
	{
		dwOldHelpTopic = ChangeHelpTopic(IDH_SETOWNERTRUST);
	}
	else
	{
		dwOldHelpTopic = ChangeHelpTopic(IDH_EDITOWNERTRUST);
	}

	// Set the title for the dialog box to set or edit.
	//.................................................
	dwOwnerOperation = dwOperation;

	// Get the trust byte and its address.
	//....................................
	__asm
	{
		mov		edi,lpKeyBuffer1
		mov		cl,byte ptr [edi]
		mov		dwCtb_Byte,ecx
		mov		lpKeyBufferDup1,edi
	}
	GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

	__asm
	{
		mov		edi,lpKeyBufferDup1
		add		edi,CTB_SIZE
		add		edi,edx
		add		edi,eax
		mov		cl,byte ptr [edi]
		mov		dwCtb_Byte,ecx
		mov		lpKeyBufferDup1,edi
	}
	GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

	__asm
	{
		mov		edi,lpKeyBufferDup1
		add		edi,CTB_SIZE
		add		edi,edx
		mov		cl,byte ptr [edi]
		mov		TrustByte,cl
		mov		TempCL,cl
		and		TrustByte,OWNER_SIG_MASK
		mov		lpOwnerTrustByte,edi
		add		edi,eax

		// Now get the user id. It could be the next packet, or the
		// second packet after a compromise certificate.
		//.........................................................
	L1:	mov		al,byte ptr [edi]
		mov		cl,al
		mov		dwCtb_Byte,ecx
		mov		lpKeyBufferDup1,edi
		and		al,CTB_MASK
		cmp		al,CTB_USER_ID
		je		L2
	}
	GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

	__asm
	{
		mov		edi,lpKeyBufferDup1
		add		edi,CTB_SIZE
		add		edi,edx
		add		edi,eax
		jmp		L1
	L2:
	}
	GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

	__asm
	{
		mov		edi,lpKeyBufferDup1
		add		edi,CTB_SIZE
		add		edi,edx
		cmp		eax,MAX_USER_ID
		jbe		L3
		mov		eax,MAX_USER_ID
	L3:	mov		esi,edi
		mov		ecx,eax
		mov		edi,offset TempOwnerId
		rep		movsb
	}

	// Setup the current trust setting for the dialog box.
	//....................................................
	if (TrustByte == NOT_INITIALIZED)
	{
		uiCurrentTrustSetting = IDS_UNINITTRUST;
	}
	else if (TrustByte == UNKNOWN_OWNER)
	{
		uiCurrentTrustSetting = IDS_UNKNOWNOWNER;
	}
	else if (TrustByte == NOT_TRUST)
	{
		uiCurrentTrustSetting = IDS_NOTRUSTTOSIGN;
	}
	else if (TrustByte == MARGINAL_TRUST)
	{
		uiCurrentTrustSetting = IDS_USLYTRUSTTOSIGN;
	}
	else if (TrustByte == COMPLETE_TRUST)
	{
		uiCurrentTrustSetting = IDS_AWLSTRUSTTOSIGN;
	}
	else if (TrustByte == ON_SECRET_RING)
	{
		uiCurrentTrustSetting = IDS_ONSECRETKEYRING;
	}
	else
	{
		uiCurrentTrustSetting = IDS_UNKNOWN;
	}
	// Reset the trust byte.
	//......................
	__asm
	{
		mov		cl,TempCL
		and		cl,not OWNER_SIG_MASK
		mov		TrustByte,cl
	}
	// If the key is a buckstop key or disabled, inform
	// the user via a message box that he is not allowed
	// to edit these keys.
	//..................................................
	if (TempCL & (BUCKSTOP_BIT | DISABLED_BIT))
	{
		// Display a message box about buckstop or disabled keys.
		// Only display it if called from editing owner trust.
		//.......................................................
		CheckEditError(IDS_EDITOWNERTRUST,&TempOwnerId,NULL,IDS_NOEDITOWNRTRUST,
					   IDS_EDITOTSKIPPED,MB_ICONEXCLAMATION | MB_OK,MB_ICONEXCLAMATION,0);

		bFinalResult = TRUE;
		goto OwnerTrustEnd;
	}
	// Do not trap the tab key for this dialog box.
	//.............................................
	bTrapTheTabKey = FALSE;

	// Display the dialog box for editing the owner trust byte.
	//.........................................................
	iDlgResult = DialogBox(hInst,TEXT("PUBLICKEYOWNERTRUST"),hMainWindow,
						  (DLGPROC)SetTheOwnerTrustProc);

	// Reset the tab key setting.
	//...........................
	bTrapTheTabKey = bCurrentTabKeySetting;

	// See if we had a system error in creating the dialog box.
	//.........................................................
	if (iDlgResult == -1)
	{
		ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
		goto OwnerTrustEnd;
	}
	// If we closed the dialog box without selecting anything
	// do not change the owner trust setting.
	//........................................................
	if (iDlgResult == 0)
	{	
		bFinalResult = TRUE;
		goto OwnerTrustEnd;
	}
	// Set the owner trust according to our selection.
	//................................................
	if (iDlgResult == IDC_DONTKNOW)
	{
		TrustByte |= UNKNOWN_OWNER;
	}
	else if (iDlgResult == IDC_NO1)
	{
		TrustByte |= NOT_TRUST;
	}
	else if (iDlgResult == IDC_USUALLY)
	{
		TrustByte |= MARGINAL_TRUST;
	}
	else
	{
		TrustByte |= COMPLETE_TRUST;
	}

	EmptyTheMessageQue();

	// Set the owner trust packet and write the record back to disk.
	//..............................................................
	__asm
	{
		mov		edi,lpOwnerTrustByte
		mov		al,TrustByte
		mov		byte ptr [edi],al
	}
	// Write the record.
	//..................
	bResult = WriteRecord1();
	if (!bResult)
	{
		goto OwnerTrustEnd;
	}

	bKeysEdited = TRUE;
	bWeChangedIt = TRUE;
	bFinalResult = TRUE;

	OwnerTrustEnd:

	ChangeHelpTopic(dwOldHelpTopic);
	return(bFinalResult);
}

// CALLBACK procedure for the set owner trust dialog box.
//.......................................................
LRESULT CALLBACK SetTheOwnerTrustProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	UINT		uiLocalOperation;
	int			iMessageBoxResult;
	TCHAR		szOperation[96];

	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);

			// Set the proper caption for the dialog box.
			//...........................................
			if (dwOwnerOperation == SET_OWNER_TRUST)
			{
				uiLocalOperation = IDS_SETOWNERTRUST;
			}
			else
			{
				uiLocalOperation = IDS_EDITOWNERTRUST;
			}
			LoadString(hInst,uiLocalOperation,szOperation,sizeof(szOperation));
			SendMessage(hDlg,WM_SETTEXT,0,(LPARAM)(LPCTSTR)szOperation);

			// Set the owner id.
			//..................
			SetDlgItemTextFmt(hDlg,IDC_OWNER,(LPCTSTR)&TempOwnerId);

			// Set the current trust setting.
			//...............................
			LoadString(hInst,uiCurrentTrustSetting,szOperation,sizeof(szOperation));
			SetDlgItemText(hDlg,IDC_SETTING,(LPCTSTR)szOperation);
			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			return(TRUE);
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				case IDC_DONTKNOW:
				{
					EndDialog(hDlg,IDC_DONTKNOW);
				}
				break;

				case IDC_NO1:
				{
					EndDialog(hDlg,IDC_NO1);
				}
				break;

				case IDC_USUALLY:
				{
					EndDialog(hDlg,IDC_USUALLY);
				}
				break;

				case IDC_ALWAYS:
				{
					EndDialog(hDlg,IDC_ALWAYS);
				}
				break;

				case IDC_MYHELP:
				{
					DisplayMyHelp(hDlg);
				}
				break;
			}
			break;
		}

		case WM_CLOSE:
		{
			iMessageBoxResult = MessageBoxProc(hDlg,IDS_QUESTION,IDS_NOOWNERSELECTED,
											   MB_ICONQUESTION | MB_YESNO,MB_ICONQUESTION,0);
			if (iMessageBoxResult == IDYES)
			{
				EndDialog(hDlg,0);
			}
			return(0);
		}

		case WM_HELP:
		{
			PopupHelp(hDlg,lParam);
		}
		break;

		case WM_CONTEXTMENU:
		{
			WhatsThis(hDlg,(HWND)wParam,lParam);
		}
		break;
	
		default:
			return(FALSE);
	}
	return(TRUE);
}
